include <BOSL2/std.scad>

pill_dimensions = [21.6,7.64]; // (length;diameter) mm See https://www.lfacapsulefillers.com/capsule-size-chart
pill_capacity = [2,4];

thickness = 2; //mm (this needs to be at least 2x your nozzle size)
rounding = pill_dimensions.y/2; //mm

resolution = 100;
img_res = [570,409];

x1 = [pill_dimensions.x*pill_capacity.x,pill_dimensions.y*pill_capacity.y,pill_dimensions.y/2+thickness*2];

dim = [x1.x+thickness,x1.y+thickness,thickness/8];

echo(dim);

module card_base(dims=dim){
cuboid(
    dims, rounding=rounding,
    edges=[RIGHT+FRONT,RIGHT+BACK,LEFT+FRONT,LEFT+BACK],
    anchor=BOT+LEFT+FRONT,
    $fn=resolution
);
}

intersection(){
translate([0,0,dim.z*3+dim.z])
scale([dim.x/img_res.x,dim.y/img_res.y,0.01*dim.z*3])
surface(file = "picture-v1.png", invert = true);
translate([0,0,dim.z])
card_base(dims=[dim.x,dim.y,dim.z*3]);
}

card_base();
